Imports System.Collections

'
' Egzemplarze tej klasy odpowiadaj za zarzdzanie pamici podrczn z obiektami
' profili pracownikw i realizacj zada zlecanych przez obiekt klasy CacheManager.
'
Public Class EmployeeCache
    ' Wykorzystujemy list do identyfikowania najdawniej uywanego obiektu
    ' profilu pracownika. Sam pami podrczn zaimplementowano w formie
    ' obiektu klasy Hashtable. Wartoci skadowane w tej kolekcji typu
    ' Hashtable maj posta list obiektw wskazujcych na waciwe obiekty
    ' klasy EmployeeProfile.
    Private cache As New Hashtable()

    ' Zmienna list reprezentuje list wskazujc na najdawniej i ostatnio
    ' uywany obiekt klasy EmployeeProfile.
    Private list As New DoublyLinkedList()

    ' Maksymalna liczba obiektw klasy EmployeeProfile, ktre mog by jednoczenie
    ' przechowywane w pamici podrcznej.
    Private MAX_CACHE_SIZE As Integer = 80

    ' Liczba obiektw klasy EmployeeProfile, ktre s aktualnie skadowane w pamici podrcznej.
    Private currentCacheSize As Integer = 0

    ' Obiekty przekazywane na wejciu tej procedury w zaoeniu maj by dodawane
    ' do pamici podrcznej. Metoda AddEmployee nie gwarantuje jednak, e przekazany obiekt
    ' rzeczywicie zostanie dodany do pamici podrcznej, jeli byoby to sprzeczne
    ' ze stosowan polityk dodawania obiektw. Niniejsza metoda moe te usuwa
    ' obiekty, ktre ju s skadowane w pamici podrcznej i  tym samym 
    ' przygotowywa miejsce dla nowych obiektw.
    '
    ' emp  Egzemplarz egzemplarz klasy employeeProfile, ktry jest kandydatem do skadowania w pamici podrcznej.
    '
    Public Sub AddEmployee(ByVal emp As EmployeeProfile)
        Dim id As EmployeeID = emp.ID

        If cache(id) Is Nothing Then ' Jeli dany profil nie jest skadowany w pamici podrcznej.
            ' Dodaje dany profil do pamici podrcznej i okrela go jako profil ostatnio uywany.
            Dim node As CachedEmployeeNode
            If currentCacheSize >= MAX_CACHE_SIZE Then
                ' Usuwa z pamici podrcznej ostatnio uywany obiekt
                ' klasy EmployeeProfile.
                node = CType(list.RemoveFirst(), CachedEmployeeNode)
                cache.Remove(node)
            Else
                node = New CachedEmployeeNode()
            End If
            ' Umieszcza w pamici podrcznej ostatnio uywany profil pracownika.
            node.CachedEmployee = emp
            list.AddLast(node)
            cache(id) = node
            currentCacheSize += 1
        Else  ' Jeli dany profil jest ju skadowany w pamici podrcznej.
            ' Procedura AddEmployee nie powinna by wywoywana w sytuacji, gdy dany obiekt
            ' znajduje si ju w pamici podrcznej. Poniewa ten blok kodu ma obsugiwa tego
            ' rodzaju przypadki, ustawiamy wskazany obiekt jako ostatnio uywany.
            FetchEmployee(id)
        End If ' if cache(id) Is Nothing
    End Sub 'AddEmployee

    '
    ' Zwraca obiekt klasy EmployeeProfile zwizany z danym na wejciu identyfikatorem
    ' typu EmployeeID lub warto Nothing, jeli aden egzemplarz klasy EmployeeProfile
    ' nie jest zwizany z takim obiektem klasy EmployeeID.
    ' id -  Obiekt klasy the EmployeeID reprezentujcy pracownika, ktrego profil  to retrieve a profile forma zosta zwrcony. 
    Public Function FetchEmployee(ByVal id As EmployeeID) As EmployeeProfile
        Dim employeeNode As CachedEmployeeNode = _
            CType(cache(id), CachedEmployeeNode)
        If employeeNode Is Nothing Then
            Return Nothing
        End If
        ' Move employeeNode to the end of the list to indicate
        ' it is most recently used.
        employeeNode.Remove()
        list.AddLast(employeeNode)
        Return employeeNode.CachedEmployee
    End Function 'FetchEmployee

End Class 'EmployeeCache
